jQuery(function($){

    var strlen = function( text ) {
        var count = 0;

        for ( var i = 0; i < text.length; i++ ) {
            if ( "\n" == text[i] || "\r" == text[i] ) {
                continue;
            }

            count++;
        }

        return count;
    };

    var truncate = function ( text, limit ) {
        var res = "";
        var i = 0;
        var length = 0;

        while ( true ) {
            if ( length == limit || i == text.length ) {
                break;
            }

            res += text[i];

            if ( "\n" != text[i] && "\r" != text[i] ) {
                length++;
            }

            i++;
        }

        return res;
    };

    var html_filter = function ( text, limit ) {
        var text_arr = text.split(/(<[^>]+>)/i);
        var textLength = 0;
        var cut_text = "";
        text_arr.forEach( function( part ) {
            var html_filter = part.replace( /(<([^>]+)>)/ig,"" );

            if ( textLength + strlen( html_filter ) <= limit ) {
                textLength += strlen( html_filter );
                cut_text += part;
            } else {
                cut_text += truncate( part, limit - textLength );
                textLength = limit;
            }
        } );

        return [ cut_text, textLength ];
    }

    $( '#wpbdp-submit-listing' ).on( 'keyup keydown', '.wpbdp-form-field[data-limit-characters="1"] textarea, .wpbdp-form-field[data-limit-characters="1"] input[type="text"]', function() {
        var $field = $( this ).parents( '.wpbdp-form-field' );
        var limit  = parseInt( $field.attr( 'data-characters-limit' ), 10 );

        if ( limit > 0 ) {
            var $placeholder = $field.find( '.characters-left-placeholder' );
            var text = $(this).val();

            var textLength = 0;

            var allow_html  = parseInt( $field.attr( 'data-allow-html' ), 10 );

            allow_html = isNaN( allow_html ) ? 0 : allow_html;

            if ( $field.hasClass('wpbdp-form-field-type-textarea') && allow_html ) {
                [ text, textLength ] = html_filter( text, limit );
            } else {
                textLength = strlen( text );

                if ( textLength > limit ) {
                    text = truncate( text, limit );
                    textLength = strlen( text );
                } 
            }

            $placeholder.text( limit - textLength );
            $(this).val( text );
        }

    } );

    $( document ).on( 'tinymce-editor-setup', function( e, editor ) {
        editor.on( 'keyup keydown', function( ) {
            var $field = $( '#wpbdp-submit-listing .wpbdp-form-field[data-limit-characters="1"] textarea#' + editor.id ).parents( '.wpbdp-form-field' );
            var limit  = parseInt( $field.attr( 'data-characters-limit' ), 10 );

            if ( limit > 0 ) {
                var $placeholder = $field.find( '.characters-left-placeholder' );
                var bookmark = editor.selection.getBookmark(2, true);
                var text = editor.getContent();

                var textLength = 0;
                var cut_text = "";

                [ cut_text, textLength ] = html_filter( text, limit );

                if ( textLength === limit ) {
                    editor.setContent( cut_text );
                    editor.selection.moveToBookmark(bookmark);
                }

                $placeholder.text( limit - textLength );
            }
        } );
    } );
});
