jQuery( function( $ ) {

    $( '#wpbdp-listing-tabs' ).tabs();

    var $items = $( '.wpbdp-listing-single .other-images li' );
    var current_item = -1;

    var set_main_image = function( index ) {
        var $item = $items.get( index );
        current_item = index;

        var href = $( 'a', $item ).attr( 'href' );
        var $img = $( '<img>' ).attr( 'src', href );

        $( '.wpbdp-listing-single .current-image' ).html( $img );
    };

    $( 'a', $items ).click( function( e ) {
        e.preventDefault();
        set_main_image( $( this ).parents( 'li' ).index() );
    } );

    if ( $items.length <= 1 )
        return;

    var rotate_items = function() {
        setTimeout(rotate_items, 4000);
        current_item++;

        if ( current_item >= $items.length )
            current_item = 0;

        set_main_image( current_item );
    };

    if ( $( '.listing-content-wrapper .listing-images').hasClass( 'autoscroll' ) ) {
        rotate_items();
    }

} );
