jQuery( function( $ ) {
    var normalizeHeights = function() {
        var $list = $( '.wpbdp-listings-list' );

        if ( $list.length == 0 )
            return;

        var $items = $list.find( '.wpbdp-listing-excerpt' );
        if ( $items.length == 0 )
            return;

        if ( $list.hasClass( 'grid' ) ) {
            var max_height = Math.max.apply(null, $items.map( function(){ return $(this).height() } ).get());
            $items.height( max_height );
        } else {
            $items.height( '' );
        }
    };

    $( '.mobile-compact-list-style-selector a' ).click( function( e ) {
        e.preventDefault();

        var list_style = $( this ).attr( 'data-list-style' );

        $( '.wpbdp-listings' ).removeClass( 'grid' ).removeClass( 'list' );
        $( '.wpbdp-listings' ).addClass( list_style );

        $( this ).parent().find( 'a' ).removeClass( 'active' );
        $( this ).addClass( 'active' );
        $( this ).blur();

        normalizeHeights();
    } );

    // Make all grid boxes the same height.
    setTimeout( function(){ normalizeHeights() }, 500 );

    var $tabs = $( '.mobile-compact-listing-tabs' );
    if ( $( '> ol li', $tabs ).length == 1 ) {
        var content_id = $( '> ol li a', $tabs ).attr( 'href' );
        $( 'ol', $tabs ).remove();
        $( content_id ).show();
    } else {
        $( '.mobile-compact-listing-tabs' ).tabs( {
            active: 0,
            activate: function ( event, ui ) {
                $( window ).trigger( 'resize.reusables.breakpoints' );
                wpbdp.googlemaps.refresh_all();
            }
        } );
    }
} );
