jQuery( function( $ ) {

    $( '#wpbdp-listing-tabs' ).tabs( {
        active: 0,
        activate: function( event, ui ) {
            $( window ).trigger( 'resize.reusables.breakpoints' );
            wpbdp.googlemaps.refresh_all();
        }
    } );

    $( '.wpbdp-listings-list .wpbdp-listing:last' ).addClass( 'last' );

    var normalizeHeights = function() {
        var $list = $( '.wpbdp-listings-list' );

        if ( $list.length == 0 )
            return;

        var $items = $list.find( '.wpbdp-listing-excerpt' );
        if ( $items.length == 0 )
            return;

        if ( $list.hasClass( 'grid' ) ) {
            var max_height = Math.max.apply(null, $items.map( function(){ return $(this).height() } ).get());
            $items.height( max_height );
        } else {
            $items.height( '' );
        }
    };

    // Make all grid boxes the same height.
    setTimeout( function(){ normalizeHeights() }, 500 );

    if ( jQuery.fn.select2 ) {
        $(".wpbdp-main-box .wpbdp-form-field-association-category .wpbdp-form-field-inner .wpbdp-js-select2").selectWoo(
            {
                placeholder: elegant_grid_l10n.placeholder
            }
        );
    }

} );
